clear all
set more off
cd "C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\"

capture log close
log using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\log_files\log_step5002.log, replace


*** baseline
local str0="turnmig_rate share_age_0_24 share_age_55plus WVS_index_2 year_school share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  hh_size home_own_rate netmig_rate urban_share_500_y1990 logY_ppp  mlog_road_density city_nuts capital"

*** contribution of migration
local str1="share_age_0_24 share_age_55plus WVS_index_2 year_school share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  hh_size home_own_rate netmig_rate urban_share_500_y1990 logY_ppp  mlog_road_density city_nuts capital"

*** contribution of demographics
local str2="turnmig_rate WVS_index_2 year_school share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  hh_size home_own_rate netmig_rate urban_share_500_y1990 logY_ppp  mlog_road_density city_nuts capital"

*** contribution of trust
local str3="turnmig_rate share_age_0_24 share_age_55plus year_school share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  hh_size home_own_rate netmig_rate urban_share_500_y1990 logY_ppp  mlog_road_density city_nuts capital"

*** contribtuion of core stories
local str4="year_school share_emp_primary_sector share_emp_secondary_sector ic_EMP_share_female  hh_size home_own_rate netmig_rate urban_share_500_y1990 logY_ppp  mlog_road_density city_nuts capital"

*** contribution of core stories & controls
local str5="urban_share_500_y1990 mlog_road_density city_nuts capital"

tempname 1 
postfile `1' ScenarioSS str10 mean_OLS str10 mean_FE ///
			using C:\Dropbox\Oli\Hysteresis\workfiles_Oct_2013\output_dta\temp_Table5003, replace every(1)
	
	

foreach SS in 0 1 2 3 4 5 {
			
				use wf_step1011.dta, clear
				gen nuts_original=nuts
				gen flag_1970=1
				gen year_US=.
				gen impute_all=-1

				*** ATTN: use the final file	
				append using C:\Dropbox\Oli\Hysteresis\workfiles_Sep_2013\wf_step1031


				*** Population weights
				egen sum_age_total = sum(age_total) if smpl2==1, by(year country)
				gen pop_wgt =  age_total/sum_age_total

	
				*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
				*		Impute index of TRUST using country-level time series
				*		for the U.S.
				*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
				di "`str`SS''"
				*** impute values for variables we want to use for now
				quiet foreach var in WVS_index_2 {
							noisily di "    `var'"
							capture drop  temp_`var'
							egen temp_`var'=mean(`var') if smpl2==1 & country=="US" & year==1971, by(nuts_original)
							capture drop  temp2_`var'
							egen temp2_`var'=mean(temp_`var'), by(nuts_original)
								
							*** assume that trust index falls for US by one standard deviation	
							replace `var'=temp2_`var'+(-1) if impute_all==0 & year>1975
							
				}
				
				
				/*
				DATA FROM STEP4005
					year |  WVS_in~2      a165      f114
				---------+------------------------------
					1982 | -9.521558  1.595493  1.674119
					1990 | -9.157937  1.484944   1.91701
					1995 | -9.761727  1.643688  1.667181
					1999 | -10.17408  1.641586  2.179949
					2006 | -10.08719  1.606549  2.291308
				*/
				
				

	
	
				*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
				*		Impute only variables where intial conditions are not possible
				*		no collect in 2000s
				*~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~~
				di "`str`SS''"
				*** impute values for variables we want to use for now
				quiet foreach var of varlist ///
							`str`SS''		///
							cid_* ///
							pop_wgt ///
							{
							noisily di "    `var'"
							capture drop  temp_`var'
							egen temp_`var'=mean(`var') if smpl2==1 & country=="US" & year==1971, by(nuts_original)
							capture drop  temp2_`var'
							egen temp2_`var'=mean(temp_`var'), by(nuts_original)
										
							replace `var'=temp2_`var' if impute_all==0
							
				}
		
		
		
				
				*==============================================================
				*				OLS
				*==============================================================

				quiet reg  ue2_hyst `str0' [aw=pop_wgt]  if smpl2==1 & year==1971, robust beta 
				capture drop ue2_hyst_hat			
				predict ue2_hyst_hat, xb
				predict ue2_hyst_sd,  stdp


				
				sum ue2_hyst_hat [aw=pop_wgt] if year==2000 & country=="US" 
				local mean_OLS=string(r(mean),"%4.2f")
				
				capture drop ue2_hyst_var
				gen ue2_hyst_var=(ue2_hyst_hat-`mean_OLS')^2+ue2_hyst_sd^2				
				sum ue2_hyst_var [aw=pop_wgt] if year==2000 & country=="US" 
				local se_OLS="(" + string(sqrt(r(mean)/r(N)),"%4.2f")	+ ")"			
				
				*==============================================================
				*				FE
				*==============================================================

				quiet reg  ue2_hyst `str0' cid_* [aw=pop_wgt]  if smpl2==1 & year==1971, robust beta 
				capture drop ue2_hyst_hat			
				predict ue2_hyst_hat, xb
				
				sum ue2_hyst_hat [aw=pop_wgt] if year==2000 & country=="US" 
				local mean_FE=string(r(mean),"%4.2f")

				capture drop ue2_hyst_var				
				gen ue2_hyst_var=(ue2_hyst_hat-`mean_FE')^2+ue2_hyst_sd^2				
				
				sum ue2_hyst_var [aw=pop_wgt] if year==2000 & country=="US" 
				local se_FE="(" + string(sqrt(r(mean)/r(N)),"%4.2f")	+ ")"			
								
				post `1' (`SS') ("`mean_OLS'") ("`mean_FE'")
				post `1' (`SS') ("`se_OLS'") 	("`se_FE'")
				
				
}

postclose `1'


log close
